function createChat()
{
	new ScriptObject(chatSO);
	ChatSO.show();
	chatSO.addLine("Hey look! A chat!");
}

function chatSO::onAdd(%this)
{
	%lineCount = 7;
	
	%this.guiControl = new GuiControl();
   
	%this.lineCount = %lineCount;
	%x = 10;
	%y = 430;
	for(%i = 0; %i < %lineCount; %i++)
	{
		%this.line[%i] = new GuiTextCtrl() {
         profile = "GuiChatLineProfile";
         horizSizing = "right";
         vertSizing = "bottom";
         position = %x SPC %y;
         extent = "407 18";
         minExtent = "8 2";
         visible = "1";
         text = "";
         maxLength = "255";
         visible = 1;
      };
    %this.guiControl.add(%this.line[%i]);
    %y += 20;
	}
	
	//create typing field thing
	%edit = new GuiTextEditCtrl()
	{
    position = "10" SPC "575";
    extent = "250 18";
    minExtent = "8 2";
    visible = "1";
    text = "";
    maxLength = "130";
    visible = 0;
    Altcommand = "chatSO.sendMessage();";
    escapeCommand = "chatSO.hideEdit();";
	};
	%this.editControl = %edit;
	%this.guiControl.add(%edit);
}

function ChatSO::sendMessage(%this)
{
	%text = %this.editControl.getText();
	ChatSO.hideEdit();
	commandToServer('messageSent', %text);
	//chatMessage(%text);
}

function showChat(%val)
{
	if(%val)
	{
		ChatSO.showEdit();
	}
}

function chatSO::addLine(%this, %text)
{
	for(%i = 0; %i < %this.lineCount; %i++)
	{
		if(%this.line[%i].text $= "")
		{
			%this.line[%i].text = %text;
			return;
		}
	}
	
	//shift everything up one line and put on last line
	for(%i = 0; %i < %this.lineCount - 1; %i++)
	{
		%this.line[%i].text = %this.line[%i + 1].text;
	}
	%this.line[%this.lineCount - 1].text = %text;
}

function chatSO::show(%this)
{
	canvas.pushDialog(%this.guiControl);
}

function ChatSO::showEdit(%this)
{
	%this.editControl.visible = 1;
	%this.editControl.makeFirstResponder(1);
}

function ChatSO::hideEdit(%this)
{
	%this.editControl.text = "";
	%this.editControl.visible = 0;
	%this.editControl.makeFirstResponder(0);
}

function chatSO::hide(%this)
{
	canvas.popDialog(%this.guiControl);
}

function chatMessage(%msg)
{
	chatSO.addLine(%msg);
}

function clientCmdChatMessage(%text)
{
	chatSO.addLine(%text);
}

schedule(500, 0, "createChat");